using System;
using System.Reflection;
using System.Data;
using System.Collections;

using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Product Type business object layer class. 
		///</summary>

		#endregion

	public class ProductType: BOL.BaseBusinessObject
	{
        /// <summary>
        /// Frozen blood product types
        /// E004,E005,E010,E012,E025,E028,E030,E032
        /// </summary>
        private static readonly string[] FROZENBLOODPRODUCTTYPE = {Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.FrozenRedBloodCells),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.FrozenRejuvenatedRedBloodCells),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.FreshFrozenPlasma),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.ApheresisFreshFrozenPlasma),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.FrozenApheresisPlatelets),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.Cryoprecipitate),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.PooledCryoprecipitate),
																	  Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.ApheresisCryoprecipitate)};  
        /// <summary>
        /// 
        /// </summary>
        private string _productTypeCode;
        /// <summary>
        /// 
        /// </summary>
		private string _productTypeText;
		/// <summary>
		/// This holds the modifications that can be applied to a unit.
		/// </summary>
		private BOL.BloodProductModifications _bloodProductModifications;

        /// <summary>
        /// CR3558 - New field tied to BR_2.07 and PT_1.06
        /// </summary>
        private bool _aborhConfirmationRequired = false;
		#region Binding Change Events

		/// <summary>
		/// ProductTypeCodeChanged handler
		/// </summary>
		public event EventHandler ProductTypeCodeChanged;

		/// <summary>
		/// ProductTypeTextChanged handler
		/// </summary>
		public event EventHandler ProductTypeTextChanged;

		/// <summary>
		/// ProductTypeCodeChanged event
		/// </summary>
		protected virtual void OnProductTypeCodeChanged()
		{
			if(ProductTypeCodeChanged != null)
				ProductTypeCodeChanged(this, EventArgs.Empty);
		}

		/// <summary>
		/// ProductTypeTextChanged event
		/// </summary>
		protected virtual void OnProductTypeTextChanged()
		{
			if(ProductTypeTextChanged != null)
				ProductTypeTextChanged(this, EventArgs.Empty);
		}

		#endregion

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="599"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>An empty product type business object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="540"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Product Type empty class constructor
		/// </summary>
		public ProductType()
		{
			this.Clear();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1236"> 
		///		<ExpectedInput>A valid product type ID</ExpectedInput>
		///		<ExpectedOutput>A valid product type business object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="584"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Product Type class constructor
		/// </summary>
		public ProductType(string ID)
		{
			this.ProductTypeCode =ID;
			//this._bloodProductModifications = new BOL.BloodProductModifications(this.ProductTypeCode);

		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2414"> 
		///		<ExpectedInput>DataRow containing ProductType data</ExpectedInput>
		///		<ExpectedOutput>ProductType object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2858"> 
		///		<ExpectedInput>Null</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates ProductType object and populates it with data from DataRow
		/// </summary>
		/// <param name="dr"></param>
		public ProductType(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="600"> 
		///		<ExpectedInput>ProductType object</ExpectedInput>
		///		<ExpectedOutput>Product type code</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="659"> 
		///		<ExpectedInput>Product type code</ExpectedInput>
		///		<ExpectedOutput>ProductType object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="660"> 
		///		<ExpectedInput>Product type code with invalid format</ExpectedInput>
		///		<ExpectedOutput>Business Object Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="661"> 
		///		<ExpectedInput>Product type code with invalid length</ExpectedInput>
		///		<ExpectedOutput>Business Object Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets product type code.
		/// Setting fires a change event.
		/// </summary>
        public string ProductTypeCode
        {
            get 
            { 
                return _productTypeCode;
            }
            set 
            {
                string fieldName = "Product type code";
                if (value != null)
                {
                    if (!((value.Length == 0) || (value.Length == 4)))
                    {
						string errorMessage = Common.StrRes.SysErrMsg.Common.FieldLengthError(
												Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name, true),
												"1", "4").ResString;
                        throw new BusinessObjectException(errorMessage);
                    }
                    System.CharEnumerator charEnum = value.GetEnumerator();
                    if (charEnum != null && charEnum.MoveNext())
                    {
                        if (!char.IsLetter(charEnum.Current))
                        {
                            string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidFormat(fieldName).ResString;
                            throw new BusinessObjectException(errorMessage);
                        }
                    }				
                    while (charEnum.MoveNext())
                    {
                        if (!char.IsDigit(charEnum.Current))
                        {
                            string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidFormat(fieldName).ResString;
                            throw new BusinessObjectException(errorMessage);
                        }
                    }
                }
                _productTypeCode = value;
                RuleBroken(MethodBase.GetCurrentMethod().Name,(value == null || value.Length != 4));
                OnProductTypeCodeChanged();
            }
        }


        /// <summary>
        /// CR3558 - If false, the product type is Limited until confirmed in UC2 (CR3558)
        /// This should only be SET by constructors!!!!
        /// </summary>
        public bool AboRhConfirmationRequired
        {
            get
            {
                return(this._aborhConfirmationRequired);
            }
            set
            {
                this._aborhConfirmationRequired = value;
            }
        }

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6530"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6531"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This saves the developer from having to type a bunch of hooey
		/// </summary>
		public Common.ProductType ProductTypeEnum
		{
			get
			{
				return Common.Utility.GetProductTypeFromProductTypeCode(this.ProductTypeCode);
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1240"> 
		///		<ExpectedInput>Initialized product type</ExpectedInput>
		///		<ExpectedOutput>Valid blood product modifications</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2025"> 
		///		<ExpectedInput>null BloodProductModifications</ExpectedInput>
		///		<ExpectedOutput>Broken Rule</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// BloodProductModifications object
		/// </summary>
		public BOL.BloodProductModifications BloodProductModifications
		{
			get
			{
				if (this._bloodProductModifications == null)
				{
					this._bloodProductModifications = new BOL.BloodProductModifications();
				}
				return this._bloodProductModifications;
			}
			set
			{
				this._bloodProductModifications = value;
				RuleBroken(MethodBase.GetCurrentMethod().Name,(value==null));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="602"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="662"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// 
		/// <summary>
		/// Gets or sets product type description information.
		/// Setting raises a change event.
		/// </summary>
		/// <remarks>
		/// 01.06.2006 D. Askew: Removed the requirement and, consequently, 
		/// the unit test, that specifies a max text length of 60 characters.
		/// The requirement is no longer valid.
		/// </remarks>
		public string ProductTypeText
		{
			get 
			{ 
				return _productTypeText; 
			}
			set 
			{ 
				_productTypeText = value;
				OnProductTypeTextChanged();
			}
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6528"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6529"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a IsTypeFrozen boolean
		/// </summary>
        public bool IsTypeFrozen
        {
            get
            {
                ArrayList al = new ArrayList(FROZENBLOODPRODUCTTYPE);
                return al.Contains(this._productTypeCode);
            }
        }


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="601"> 
		///		<ExpectedInput>Populated ProductType object</ExpectedInput>
		///		<ExpectedOutput>Clear ProductType object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="585"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Virtual method to clear properties of product type class
		/// </summary>
		public virtual void Clear()
		{
			this.ProductTypeCode = string.Empty;
			this.ProductTypeText = string.Empty;
			this.BloodProductModifications = new BOL.BloodProductModifications();
            this.AboRhConfirmationRequired = false;    //CR3558
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="326"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table of product types</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="586"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Calls data access layer to return a data table of product types. Can be used to populate a combobox.
		/// </summary>
		/// <returns></returns>
        public static DataTable GetProductTypeLookupList()
        {
            return (DAL.ProductType.GetProductTypeLookupList());
        }

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1237"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="588"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			this.ProductTypeCode = dtRow.IsNull(Common.VbecsTables.ProductType.ProductTypeCode) ? string.Empty : dtRow[Common.VbecsTables.ProductType.ProductTypeCode].ToString().Trim();
			this.ProductTypeText = dtRow.IsNull(Common.VbecsTables.ProductType.ProductTypeName) ? string.Empty : dtRow[Common.VbecsTables.ProductType.ProductTypeName].ToString().Trim();
            this.AboRhConfirmationRequired = dtRow.IsNull(Common.VbecsTables.ProductType.AboRhConfirmationRequired) ? false : (bool)dtRow[Common.VbecsTables.ProductType.AboRhConfirmationRequired];   //CR3558
		}




	}
}
